/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.world.biomes;

import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiomeBuilder;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiomeSettings;
import org.betterx.bclib.api.v2.levelgen.surface.SurfaceRuleBuilder;
import org.betterx.bclib.api.v2.levelgen.surface.rules.Conditions;
import org.betterx.bclib.api.v2.levelgen.surface.rules.NoiseCondition;
import org.betterx.betternether.noise.OpenSimplexNoise;
import org.betterx.betternether.registry.NetherEntities;
import org.betterx.betternether.registry.NetherFeatures;
import org.betterx.betternether.registry.features.placed.NetherObjectsPlaced;
import org.betterx.betternether.registry.features.placed.NetherTreesPlaced;
import org.betterx.betternether.registry.features.placed.NetherVegetationPlaced;
import org.betterx.betternether.registry.features.placed.NetherVinesPlaced;
import org.betterx.betternether.world.NetherBiome;
import org.betterx.betternether.world.NetherBiomeConfig;

public class CrimsonPinewood
extends NetherBiome {
    private static final OpenSimplexNoise TERRAIN = new OpenSimplexNoise(614L);

    public CrimsonPinewood(ResourceKey<Biome> biomeID, BCLBiomeSettings settings) {
        super(biomeID, settings);
    }

    public static class Config
    extends NetherBiomeConfig {
        public Config(String name) {
            super(name);
        }

        @Override
        protected void addCustomBuildData(BCLBiomeBuilder builder) {
            builder.fogColor(51, 3, 3).loop((Holder)SoundEvents.f_11954_).additions((Holder)SoundEvents.f_11901_).mood((Holder)SoundEvents.f_12007_).music((Holder)SoundEvents.f_12157_).particles((ParticleOptions)ParticleTypes.f_123784_, 0.025f).feature(NetherFeatures.NETHER_RUBY_ORE).feature(NetherTreesPlaced.CRIMSON_PINE).feature(NetherObjectsPlaced.STALAGMITE).feature(NetherVegetationPlaced.WART_BUSH).feature(NetherVegetationPlaced.VEGETATION_CRIMSON_GLOWING_WOODS).feature(NetherVinesPlaced.GOLDEN_VINE).feature(NetherObjectsPlaced.STALACTITE).feature(NetherVegetationPlaced.WALL_MUSHROOM_RED_WITH_MOSS).addNetherClimateParamater(0.35f, 0.1f, 0.0f).genChance(0.3f);
        }

        @Override
        public <M extends Mob> int spawnWeight(NetherEntities.KnownSpawnTypes type) {
            int res = super.spawnWeight(type);
            switch (type) {
                case HOGLIN: 
                case FLYING_PIG: {
                    res = type.weight;
                    break;
                }
                case NAGA: {
                    res = 0;
                }
            }
            return res;
        }

        @Override
        public BCLBiomeBuilder.BiomeSupplier<NetherBiome> getSupplier() {
            return CrimsonPinewood::new;
        }

        @Override
        public SurfaceRuleBuilder surface() {
            return super.surface().chancedFloor(Blocks.f_50451_.m_49966_(), Blocks.f_50699_.m_49966_(), (NoiseCondition)Conditions.FORREST_FLOOR_SURFACE_NOISE_B);
        }
    }
}

